﻿//============================================
// filename: main.c
// chip    : CSU38F20
// author  :
// date    : 2020-12-07
//============================================
#include "CSU38F20.h"
#include "timer4.h"

//============================================
// interrupt function
//============================================
void INT_FUNCTION(void) interrupt
{
	if(TM4IF && TM4IE)
	{
		TM4IF = 0;
		PT1_0 = ~PT1_0;
	}
}

//============================================
// program start
//============================================
void main()
{
	unsigned char mode = 0;
	GIE = 0;
	timer4_init();	//时钟为cpuclk/32，62.5KHz
	PWM4STALL = 0;	//ICD调试stall（例如单步）时，定时器4单端PWM输出低电平，此配置取决于外围硬件情况，用于在芯片调试暂停时保护外围硬件不会受损
	switch(mode)
	{
		case 0:		//计数器模式
		{
			PT1EN_0 = 1;	//PT1.0为数字输出口，无上拉
			PT1PU_0 = 0;
			PT1CON = 0;
			PT1_0 = 0;
			
			T4OUT = 0;		//不做PWM/蜂鸣器输出
			PWM4OUT = 0;
			
			timer4_set_pwm_period(TIMER4_COUNT);	//每4ms溢出一次
		}break;
		
		case 1:		//普通PWM模式
		{		
			PT3EN_6 = 1;	//PT3.6为PWM4输出口,数字输出口，无上拉
			PT3PU_6 = 0;
			PT3CON_6 = 0;
			
			T4OUT = 0;		//PWM4输出
			PWM4OUT = 1;
			
			timer4_set_pwm_period(TIMER4_COUNT);	//频率为250Hz
			timer4_set_pwm_duty(TIMER4_PWM_DUTY_50);	//占空比为50%
		}break;
		
		case 2:		//蜂鸣器模式
		{
			PT3EN_6 = 1;	//PT3.6为蜂鸣器输出口,数字输出口，无上拉
			PT3PU_6 = 0;
			PT3CON_6 = 0;
			
			T4OUT = 1;		//蜂鸣器输出
			PWM4OUT = 0;
			
			T4RATE_0 = 0;
			T4RATE_1 = 0;
			T4RATE_2 = 1;
			T4RATE_3 = 1;	//时钟修改为MCK/16，2MHz
			
			timer4_set_pwm_period(TIMER4_COUNT);	//4KHz，占空比50%
		}break;

		default:mode = 0;
	}
	timer4_count_clr();		//清零计数器
	timer4_enable();	//使能定时器4
	timer4_int_enable();	//使能定时器4中断
	while(1);
}
